#ifndef __DSP_H__
#define __DSP_H__

class DSP {
public:
	DSP();
	~DSP();
	void Resize(int _order, bool sevenMeg);
	void Process(float *in);
	void BuildWindow();
	int Size() const { return size; }
	int Order() const { return order; }
	const float* GetResults() const { return results; }
	void Correct(float *corr);

private:
	int order;
	int size;
	bool sevenMeg_;
	int resultSize;
	Ipp32fc *compBuf;
	float *window;
	float *results;
	IppsFFTSpec_R_32f* fftSpec;
	IppsFFTSpec_C_32fc* cfftSpec;
};

#endif